/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.DummyGeneratorAccess;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class BucketItem
extends Item
implements DispensibleContainerItem {
    private final Fluid f_40687_;
    @Nullable
    private Direction emptyContents_direction;
    @Nullable
    private BlockPos emptyContents_clicked;
    @Nullable
    private ItemStack emptyContents_itemstack;
    private final Supplier<? extends Fluid> fluidSupplier;

    @Deprecated
    public BucketItem(Fluid p_40689_, Item.Properties p_40690_) {
        super(p_40690_);
        this.f_40687_ = p_40689_;
        this.fluidSupplier = p_40689_.delegate;
    }

    public BucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(builder);
        this.f_40687_ = null;
        this.fluidSupplier = supplier;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level p_40703_, Player p_40704_, InteractionHand p_40705_) {
        BlockHitResult blockhitresult;
        ItemStack itemstack = p_40704_.m_21120_(p_40705_);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)p_40704_, (Level)p_40703_, (ItemStack)itemstack, (HitResult)(blockhitresult = BucketItem.m_41435_(p_40703_, p_40704_, this.f_40687_ == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE)));
        if (ret != null) {
            return ret;
        }
        if (blockhitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)((Object)itemstack));
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)((Object)itemstack));
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos blockpos1 = blockpos.m_142300_(direction);
        if (p_40703_.m_7966_(p_40704_, blockpos) && p_40704_.m_36204_(blockpos1, direction, itemstack)) {
            BlockPos blockpos2;
            if (this.f_40687_ == Fluids.f_76191_) {
                BlockState blockstate1 = p_40703_.m_8055_(blockpos);
                if (blockstate1.m_60734_() instanceof BucketPickup) {
                    BucketPickup bucketpickup = (BucketPickup)((Object)blockstate1.m_60734_());
                    ItemStack dummyFluid = bucketpickup.m_142598_(DummyGeneratorAccess.INSTANCE, blockpos, blockstate1);
                    if (dummyFluid.m_41619_()) {
                        return InteractionResultHolder.m_19100_((Object)((Object)itemstack));
                    }
                    PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((ServerLevel)((ServerLevel)p_40703_), (Player)p_40704_, (BlockPos)blockpos, (BlockPos)blockpos, (Direction)blockhitresult.m_82434_(), (ItemStack)itemstack, (Item)dummyFluid.m_41720_());
                    if (event.isCancelled()) {
                        ((ServerPlayer)p_40704_).f_8906_.m_141995_((Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)((Object)p_40703_), blockpos));
                        ((ServerPlayer)p_40704_).getBukkitEntity().updateInventory();
                        return InteractionResultHolder.m_19100_((Object)((Object)itemstack));
                    }
                    ItemStack itemstack1 = bucketpickup.m_142598_(p_40703_, blockpos, blockstate1);
                    if (!itemstack1.m_41619_()) {
                        p_40704_.m_36246_(Stats.f_12982_.m_12902_(this));
                        bucketpickup.getPickupSound(blockstate1).ifPresent(p_150709_ -> p_40704_.m_5496_((SoundEvent)((Object)p_150709_), 1.0f, 1.0f));
                        p_40703_.m_142346_(p_40704_, GameEvent.f_157816_, blockpos);
                        ItemStack itemstack2 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)p_40704_, (ItemStack)CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)event.getItemStack()));
                        if (!p_40703_.f_46443_) {
                            CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)p_40704_, itemstack1);
                        }
                        return InteractionResultHolder.m_19092_((Object)((Object)itemstack2), (boolean)p_40703_.m_5776_());
                    }
                }
                return InteractionResultHolder.m_19100_((Object)((Object)itemstack));
            }
            BlockState blockstate = p_40703_.m_8055_(blockpos);
            BlockPos blockPos = blockpos2 = this.canBlockContainFluid(p_40703_, blockpos, blockstate) ? blockpos : blockpos1;
            if (this.emptyContents(p_40704_, p_40703_, blockpos2, blockhitresult, blockhitresult.m_82434_(), blockpos, itemstack)) {
                this.m_142131_(p_40704_, p_40703_, itemstack, blockpos2);
                if (p_40704_ instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)p_40704_, blockpos2, itemstack);
                }
                p_40704_.m_36246_(Stats.f_12982_.m_12902_(this));
                return InteractionResultHolder.m_19092_((Object)((Object)BucketItem.m_40699_(itemstack, p_40704_)), (boolean)p_40703_.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)((Object)itemstack));
        }
        return InteractionResultHolder.m_19100_((Object)((Object)itemstack));
    }

    public static ItemStack m_40699_(ItemStack p_40700_, Player p_40701_) {
        return !p_40701_.m_150110_().f_35937_ ? new ItemStack(Items.f_42446_) : p_40700_;
    }

    public void m_142131_(@Nullable Player p_150711_, Level p_150712_, ItemStack p_150713_, BlockPos p_150714_) {
    }

    public boolean m_142073_(@Nullable Player p_150716_, Level p_150717_, BlockPos p_150718_, @Nullable BlockHitResult p_150719_) {
        boolean flag1;
        if (!(this.f_40687_ instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockstate = p_150717_.m_8055_(p_150718_);
        Block block = blockstate.m_60734_();
        Material material = blockstate.m_60767_();
        boolean flag = blockstate.m_60722_(this.f_40687_);
        boolean bl = flag1 = blockstate.m_60795_() || flag || block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)((Object)p_150717_), p_150718_, blockstate, this.f_40687_);
        if (flag1 && p_150716_ != null) {
            PlayerBucketEmptyEvent event = null;
            try {
                ServerLevel serverLevel = (ServerLevel)p_150717_;
                event = CraftEventFactory.callPlayerBucketEmptyEvent((ServerLevel)serverLevel, (Player)p_150716_, (BlockPos)p_150718_, (BlockPos)this.emptyContents_clicked, (Direction)this.emptyContents_direction, (ItemStack)this.emptyContents_itemstack);
            }
            catch (ClassCastException serverLevel) {
                // empty catch block
            }
            this.emptyContents_direction = null;
            this.emptyContents_clicked = null;
            this.emptyContents_itemstack = null;
            if (event != null && event.isCancelled()) {
                ((ServerPlayer)p_150716_).f_8906_.m_141995_((Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)((Object)p_150717_), p_150718_));
                ((ServerPlayer)p_150716_).getBukkitEntity().updateInventory();
                return false;
            }
        }
        if (!flag1) {
            return p_150719_ != null && this.m_142073_(p_150716_, p_150717_, p_150719_.m_82425_().m_142300_(p_150719_.m_82434_()), null);
        }
        if (p_150717_.m_6042_().m_63951_() && this.f_40687_.m_205067_(FluidTags.f_13131_)) {
            int i = p_150718_.m_123341_();
            int j = p_150718_.m_123342_();
            int k = p_150718_.m_123343_();
            p_150717_.m_5594_(p_150716_, p_150718_, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (p_150717_.f_46441_.nextFloat() - p_150717_.f_46441_.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                p_150717_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)((Object)p_150717_), p_150718_, blockstate, this.f_40687_)) {
            ((LiquidBlockContainer)block).m_7361_((LevelAccessor)p_150717_, p_150718_, blockstate, ((FlowingFluid)this.f_40687_).m_76068_(false));
            this.m_7718_(p_150716_, p_150717_, p_150718_);
            return true;
        }
        if (!p_150717_.f_46443_ && flag && !material.m_76332_()) {
            p_150717_.m_46961_(p_150718_, true);
        }
        if (!p_150717_.m_7731_(p_150718_, this.f_40687_.m_76145_().m_76188_(), 11) && !blockstate.m_60819_().m_76170_()) {
            return false;
        }
        this.m_7718_(p_150716_, p_150717_, p_150718_);
        return true;
    }

    public boolean emptyContents(@Nullable Player p_150716_, Level p_150717_, BlockPos p_150718_, @Nullable BlockHitResult p_150719_, Direction direction, BlockPos clicked, ItemStack itemstack) {
        this.emptyContents_direction = direction;
        this.emptyContents_clicked = clicked;
        this.emptyContents_itemstack = itemstack;
        return this.m_142073_(p_150716_, p_150717_, p_150718_, p_150719_);
    }

    protected void m_7718_(@Nullable Player p_40696_, LevelAccessor p_40697_, BlockPos p_40698_) {
        SoundEvent soundevent = this.f_40687_.getAttributes().getEmptySound();
        if (soundevent == null) {
            soundevent = this.f_40687_.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        p_40697_.m_5594_(p_40696_, p_40698_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        p_40697_.m_142346_(p_40696_, GameEvent.f_157769_, p_40698_);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (((Object)((Object)this)).getClass() == BucketItem.class) {
            return new FluidBucketWrapper(stack);
        }
        return super.initCapabilities(stack, nbt);
    }

    public Fluid getContent() {
        return this.f_40687_;
    }

    public Fluid getFluid() {
        return this.fluidSupplier.get();
    }

    private boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)((Object)worldIn), posIn, blockstate, this.f_40687_);
    }
}

